// SnareTrapTrap function 0.3 by Dewy
// The role of this function is primarily just to be a educational refference for scripters. (But it does work.)
// Coordinates have to be set, else returns False.
// $ options: ex. ---> $SnareTrap = Show; <---
//  	Show = Show operations.
//		Break = Bailout of the operation before it recycles.

MiniMod::MonitorFile(start, "SnareTrapTrap.CodeFusion.cs", "Area of effect gravity weapon.");

function SnareTrapTrap(%this, %target)
{
%targetPos = GameBase::getPosition(%this);
%client = %target;
if (Player::getArmor(%client) == False) // If the client is dead then clean up here and quit looping.
	{
	   $SnareTrap[%client] = ""; // Clean up dead entries.
	   return False;  // Bail out.
	   break;
	}
	if(%targetPos != "")
	{
	   $SnareTrap[%client] = ""; // If there's new coordinates then delete the old ones.
	   $SnareTrap[%client] = %targetPos; // Set the new ones.
	}
   else
   {
	if(%targetPos == "")
	{
	   %targetPos = $SnareTrap[%client]; // If there's no coordinants then look in the client's table.
	}
   }
// Get client position.
		%clientPos = GameBase::getPosition(%client);
		%clientX = getWord(%clientPos,0);
		%clientY = getWord(%clientPos,1);
		%clientZ = getWord(%clientPos,2);
// Setup Speed controls.
		%speed = Item::getVelocity(%client);
		%speedX = getWord(%speed, 0);
		%speedY = getWord(%speed, 1);
		%speedZ = getWord(%speed, 2);
// Setup Impulse info
		%setPosX = getWord(%targetPos,0);
		%setPosY = getWord(%targetPos,1);
		%setPosZ = getWord(%targetPos,2);
		%mathX = Vector::neg(%clientX);
		%mathY = Vector::neg(%clientY);
		%mathZ = Vector::neg(%clientZ);
		%destPosX = %setPosX+%mathX;
		%destPosY = %setPosY+%mathY;
		%destPosZ = %setPosZ+%mathZ;
		%reverseX = Vector::neg(%destPosX);
		%reverseY = Vector::neg(%destPosY);
		%reverseZ = Vector::neg(%destPosZ);
		
// Get Distance.
		%dist = Vector::getDistance(%clientPos, %targetPos);
		%Xdist = Vector::getDistance(%clientX, %setPosX);
		%Ydist = Vector::getDistance(%clientY, %setPosY);
		%Zdist = Vector::getDistance(%clientZ, %setPosZ);
// Emergency Brakes.
		%brakeX = Vector::neg(%speedX); //*0.25;
		%brakeY = Vector::neg(%speedY); //*0.25;
// Finite Vertical Navigation.
		%parachuteVal = Vector::neg(%speedZ)*0.25;
		%vertAdjust = %setPosZ-%clientZ+3;
	if(%setPosZ >= %clientZ)
	{
		if(%dist <= 25)
		{
			if(%vertAdjust <= 5)
			{
				Player::ApplyImpulse(%client, "0 0 "@%vertAdjust);
			}
			else
			{
				if(%destPosZ >= 0)
				{
					Player::ApplyImpulse(%client, "0 0 5");
				}
			}
		}
	}
 // Don't make the client go "FWING!!!" (In any direction.) :P :)
	if(%dist >= 25) // Coarse Flight.
	{
		if(%speedX <=  -10){if(%destPosX <= -1){%destPosX = -0.1;}} //%destPosX*0.010;}}
		if(%speedY <= -10){if(%destPosY <= -1){%destPosY = -0.1;}} //%destPosY*0.010;}}
		if(%speedZ <= -15){if(%destPosZ <= -1){%destPosZ = %destPosZ*0.010;}}
		if(%speedZ <= -0.000015){if(%destPosZ <= -0.000015){%destPosZ = %destPosZ+Vector::neg(%destPosZ);}}
		if(%speedX >= 10){if(%destPosX >= 1){%destPosX = %destPosX*-0.010;}} //0.1;}}
		if(%speedY >= 10){if(%destPosY >= 1){%destPosY = %destPosY*-0.010;}} //0.1;}}
		if(%speedZ >= 15){if(%destPosZ >= 1){%destPosZ = %destPosZ*-0.010;}}
		if(%speedZ >= 0.000015){if(%destPosZ >= 0.000015){%destPosZ = %destPosZ+Vector::neg(%destPosZ);}}
		if(%speedX <= -15){%destPosX = %brakeX;}
		if(%speedY <= -15){%destPosY = %brakeY;}
		if(%speedZ <= -0.1){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);}
		if(%speedX >= 15){%destPosX = %brakeX;} 
		if(%speedY >= 15){%destPosY = %brakeY;} 
		if(%speedZ >= 25){Player::ApplyImpulse(%client, "0 0 "@%vertAdjust);} //parachuteVal);} 
//		if(%speedZ <= 1){Player::ApplyImpulse(%client, "0 0 "@%vertAdjust);} //parachuteVal);} 
	}
	if(%dist <= 25) // The Alignment.
	{
		if(%dist >= 10)
		{
			if(%speedX <=  -10){if(%destPosX <= -5){%destPosX = %destPosX*0.010;}}
			if(%speedY <= -10){if(%destPosY <= -5){%destPosY = %destPosY*0.010;}}
			if(%speedZ <= -10){if(%destPosZ <= -5){%destPosZ = %destPosZ*0.010;}}
			if(%speedX >= 10){if(%destPosX >= 5){%destPosX = %destPosX*-0.010;}}
			if(%speedY >= 10){if(%destPosY >= 5){%destPosY = %destPosY*-0.010;}}
			if(%speedZ >= 10){if(%destPosZ >= 5){%destPosZ = %destPosZ*-0.010;}}
			if(%speedX >= 15){%destPosX = %brakeX;} 
			if(%speedX <= -15){%destPosX = %brakeX;}
			if(%speedY >= 15){%destPosY = %brakeY;} 
			if(%speedY <= -15){%destPosY = %brakeY;}
			if(%speedZ >= 15){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);} 
			if(%speedZ <= -0.1){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);}
			Player::ApplyImpulse(%client, "0 0 "@%vertAdjust);
		}
	}
	if(%dist <= 10) // The Landing.
	{
			if(%speedX <=  -5){if(%destPosX <= -1){%destPosX = %destPosX*0.10;}}
			if(%speedY <= -5){if(%destPosY <= -1){%destPosY = %destPosY*0.10;}}
			if(%speedZ <= -5){if(%destPosZ <= -1){%destPosZ = %destPosZ*0.10;}}
			if(%speedX >= 5){if(%destPosX >= 1){%destPosX = %destPosX*-0.10;}}
			if(%speedY >= 5){if(%destPosY >= 1){%destPosY = %destPosY*-0.10;}}
			if(%speedZ >= 5){if(%destPosZ >= 0.11){%destPosZ = %destPosZ*-0.20;}}
			if(%speedX >= 3){%destPosX = %brakeX;} 
			if(%speedX <= -3){%destPosX = %brakeX;}
			if(%speedY >= 3){%destPosY = %brakeY;} 
			if(%speedY <= -3){%destPosY = %brakeY;}
			if(%speedZ >= 15){%destPosZ = %parachuteVal;} 
			if(%speedZ <= -0.1){%destPosZ = %parachuteVal;}
	}

	// Finite Horizontal Navigation.
	if(%Xdist <= 15)
	{
		if(%Zdist >= 0) // Here we tell JetToPos to hold X&Y until Z is in the clear.
		{
			if(%Zdist <= 1)
			{
				if(%Xdist <= 20){if(%speedX <= 3){%lockX = false;}}
			}
			if(%dist <= 0)
			{
				if(%Xdist >= -20){if(%speedX >= -3){%lockX = false;}}
			}
			if(%Zdist >= 1)
			{
			   if(%Xdist <= 20){%lockX = true;}
			   if(%Xdist >= -20){%lockX = true;}
			   if(%speedZ >= 3){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);} 
			   if(%speedZ <= -0.1){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);}
			   %destPos = ""@%destPosX@" "@%destPosY@" "@%destPosZ@"";
			   Player::ApplyImpulse(%client, %destPos);
			}
		}
	}
	if(%Ydist <= 15)
	{
		if(%Zdist >= 0) // Here we tell SnareTrap to hold X&Y until Z is in the clear.
		{
			   if(%Zdist <= 1)
			   {
				if(%Ydist <= 20){if(%speedY <= 3){%lockY = false;}}
			   }
			   if(%dist <= 0)
			   {
				if(%Ydist >= -20){if(%speedY >= -3){%lockY = false;}}
			   }
				if(%Zdist >= 1)
				{
				   if(%Ydist <= 20){%lockY = true;}
				   if(%Ydist >= -20){%lockY = true;}
				}
				if(%speedZ >= 3){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);} 
				if(%speedZ <= -0.1){Player::ApplyImpulse(%client, "0 0 "@%parachuteVal);}
				%destPos = ""@%destPosX@" "@%destPosY@" "@%destPosZ@"";
				Player::ApplyImpulse(%client, %destPos);
		}
	}
if(%lockX == true)
	{
//		%destPosX = %brakeX;
	}
	if(%lockY == true)
	{
//		%destPosY = %brakeY;
	}
// Are we stuck? Hmm, lets try to fix it. (For field obsticals.)
	if(%dist >= 10)
	{
		if(%speedY <= 0.1){if(%speedY >= 0){if(%lockX != true){%destPosX = %reverseX*0.001; %stuck = true; %freeUp = "+Y axis. Reversing X to "@%reverseX;}}}
		if(%speedY >= -0.1){if(%speedY <= 0){if(%lockX != true){%destPosX = %reverseX*0.001; %stuck = true; %freeUp = "-Y axis. Reversing X to "@%reverseX;}}}
		if(%speedX <= 0.1){if(%speedX >= 0){if(%lockY != true){%destPosY = %reverseY*0.001; %stuck = true; %freeUp = "+X axis. Reversing Y to "@%reverseY;}}}
		if(%speedX >= -0.1){if(%speedX <= 0){if(%lockY != true){%destPosY = %reverseY*0.001; %stuck = true; %freeUp = "-X axis. Reversing Y to "@%reverseY;}}}
		if(%speedZ <= 0.1){if(%speedZ >= 0){%destPosZ = %reverseZ; %stuck = true; %freeUp = "+Z axis. Reversing "@%reverseZ;Player::ApplyImpulse(%client,"0 0 100");}}
		if(%speedZ >= -0.1){if(%speedZ <= 0){%destPosZ = %reverseZ; %stuck = true; %freeUp = "-Z axis. Reversing "@%reverseZ;}}
	}
	if(%dist >=25)
	{
		%destPos = ""@%destPosX@" "@%destPosY@" "@%destPosZ@""; //0";
	}
	else
	{
		%destPos = ""@%destPosX@" "@%destPosY@" "@%destPosZ@"";
	}
	if(%dist <= 2.5)
	{
		GameBase::setPosition(%client,%clientPos);
	}

// Apply the results.	
//	if(%dist >= 1) // A higher value for faster/sloppier destinations.
//	{
		if($SnareTrap != "break") // Override input. (Just in case.)
		{
			if(%destPos != "")
			{
		//Player::ApplyImpulse(%client,"0 0 "@%vertAdjust*10);
				Player::ApplyImpulse(%client, %destPos);
				schedule("SnareTrapTrap("@%client@");",0.01); // Comment out this line if if your gonna call the function from elsewhere.
				// Note: You'll need your external function call to SnareTrapTrap repeatedly untill goal is met.
				return %dist; // Tie-in for externals. (For use if external function decides when it should quit.)
			}
		}
//	}
	else
	{
		$SnareTrap[%client] = ""; // Where all done so its time to clean up.
	}
}

// Now that the SnareTrapTrap's function is out of the way let setup the more traditional stuff.

MiniMod::Turbo::Class(SnareTrapPack, 10);
// Sets ItemMax for armors that can carry class 10 items. (Medium deployables)

LightningData TrapCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $GravDamageType;
   boltLength       = 150.0;
   coneAngle        = 40.0; //40
   damagePerSec      = 0.0;
   energyDrainPerSec = 0.01;
   segmentDivisions = 4;
   numSegments      = 8;
   beamWidth        = 0.05;

   updateTime   = 120;
   skipPercent  = 0.1;
   displaceBias = 0.35;

   lightRange = 3.0;
   lightColor = { 0.15, 0.85, 0.15 };

//   soundId = SoundELFFire;
};

function TrapCharge::damageTarget(%target, %timeSlice, %damPerSec, %enDrainPerSec, %pos, %vec, %mom, %shooterId)
{
	%client = Player::getClient(%target);
	$SnareCanShoot[%client] = True;
}

$TeamItemMax[SnareTrapPack] = 15;

ItemImageData SnareTrapImage
{
	shapeFile = "camera";
	mountPoint = 2;
	mountOffset = { 0, -0.1, -0.06 };
	mountRotation = { 0, 0, 0 };
	firstPerson = false;
};

ItemData SnareTrapPack
{
	description = "Snare Trap";
	shapeFile = "camera";
	className = "Backpack";
   heading = "dDeployables";
	imageType = SnareTrapImage;
	shadowDetailMask = 4;
	mass = 2.0;
	elasticity = 0.2;
	price = 100;
	hudIcon = "deployable";
	showWeaponBar = true;
	hiliteOnActive = true;
};

function SnareTrapPack::onUse(%player,%item)
{
	if (Player::getMountedItem(%player,$BackpackSlot) != %item) {
		Player::mountItem(%player,%item,$BackpackSlot);
	}
	else {
		Player::deployItem(%player,%item);
	}
}

function SnareTrapPack::onDeploy(%player,%item,%pos)
{
	if (SnareTrapPack::deployShape(%player,%item)) {
		Player::decItemCount(%player,%item);
		%obj = newObject("","Mine","AntipersonelMine");
		addToSet("MissionCleanup", %obj);
		%pos = GameBase::getPosition(%this);
	    GameBase::setPosition(%obj, %pos);
	}
}

function SnareTrapPack::deployShape(%player,%item)
{
 	%client = Player::getClient(%player);
	if($TeamItemCount[GameBase::getTeam(%player) @ %item] < $TeamItemMax[%item]) {
		if (GameBase::getLOSInfo(%player,10)) {
			%obj = getObjectType($los::object);
				%prot = GameBase::getRotation(%player);
				%zRot = getWord(%prot,2);
				if (Vector::dot($los::normal,"0 0 1") > 0.6) {
					%rot = "0 0 " @ %zRot;
				}
				else {
					if (Vector::dot($los::normal,"0 0 -1") > 0.6) {
						%rot = "3.14159 0 " @ %zRot;
					}
					else {
						%rot = Vector::getRotation($los::normal);
					}
				}
					%camera = newObject("Camera","Turret",DeployableSnareTrap,true);
	   	      addToSet("MissionCleanup", %camera);
					GameBase::setTeam(%camera,GameBase::getTeam(%player));
					GameBase::setRotation(%camera,%rot);
					GameBase::setPosition(%camera,$los::position);
					Gamebase::setMapName(%camera,"Snare Trap #"@ $totalNumCameras++ @ " " @ Client::getName(%client));
					Client::sendMessage(%client,0,"Snare Trap deployed");
					playSound(SoundPickupBackpack,$los::position);
					$TeamItemCount[GameBase::getTeam(%camera) @ "SnareTrapPack"]++;
                              Client::setOwnedObject(%client, %camera);
                              Client::setOwnedObject(%client, %player);
					return true;
				}
				else 
					Client::sendMessage(%client,0,"Deploy position out of range");
			}
			else																						  
			 	Client::sendMessage(%client,0,"Deployable Item limit reached for " @ %item.description @ "s");

		return false;
	}


$InvList[SnareTrapPack] = 1;
$RemoteInvList[SnareTrapPack] = 1;

TurretData DeployableSnareTrap
{
	className = "Turret";
	shapeFile = "camera";
        projectileType = TrapCharge;
	maxDamage = 0.85;
        maxEnergy = 300;
        minGunEnergy = 5;
        maxGunEnergy = 1;
	sequenceSound[0] = { "deploy", SoundActivateMotionSensor };
        reloadDelay = 0.1;
	speed = 14.0;
	speedModifier = 1.5;
        range = 50;
	visibleToSensor = true;
	shadowDetailMask = 4;
	dopplerVelocity = 0;
	castLOS = true;
	supression = false;
	mapFilter = 2;
	mapIcon = "M_camera";
	debrisId = flashDebrisLarge;
	shieldShapeName = "shield";
        fireSound = SoundELFFire; //SoundPickupAmmo;
	activationSound = SoundRemoteTurretOn;
	deactivateSound = SoundRemoteTurretOff;
	explosionId = mortarExp;
        description = "Snare Trap";
	damageSkinData = "objectDamageSkins";

   isSustained     = true;
   firingTimeMS    = 5000;
   energyRate      = 1.0;
};

function DeployableSnareTrap::onAdd(%this)
{
        schedule("DeployableSnareTrap::deploy(" @ %this @ ");",1,%this);
        GameBase::setRechargeRate(%this,15);
        %this.shieldStrength = 0.005;
	if (GameBase::getMapName(%this) == "") {
                GameBase::setMapName (%this, "Snare Trap");
	}
}

function DeployableSnareTrap::deploy(%this)
{
	GameBase::playSequence(%this,1,"deploy");
}

function DeployableSnareTrap::onEndSequence(%this,%thread)
{
	GameBase::setActive(%this,true);
}

function DeployableSnareTrap::onDestroyed(%this)
{
	Turret::onDestroyed(%this);
        $TeamItemCount[GameBase::getTeam(%this) @ "SnareTrapPack"]--;
		$SnareMine = "";
}

// Override base class just in case.
function DeployableSnareTrap::onPower(%this,%power,%generator) {}
function DeployableSnareTrap::onEnabled(%this) 
{
        GameBase::setRechargeRate(%this,10);
	GameBase::setActive(%this,true);
}	

function SnareClear(%object){$SnareMine[%object] = "";}

function DeployableSnareTrap::onCollision(%this, %object)
{
//		schedule ("playSound(ShockExplosion,GameBase::getPosition(" @ %this @ "));",2.0);

	%TargetTeam = GameBase::getTeam(%object);
	%thisTeam = GameBase::getTeam(%this);
	if(%targetTeam != %thisTeam)
	{
		if($SnareMine[%object] != True)
		{
			%objectPos = Gamebase::getPosition(%object);
			%obj = newObject("","Mine","AntipersonelMine");
			addToSet("MissionCleanup", %obj);
			GameBase::setPosition(%obj, %objectPos);
//			schedule ("Player::Kill(" @ %object @ ");", 2.0);
			$SnareMine[%object] = True;
			schedule("SnareClear("@%object@");",3);
		}
	}
}

function DeployableSnareTrap::verifyTarget(%this, %target)
{
 %thisPos = GameBase::getPosition(%this);
 %targetPos = GameBase::getPosition(%target);
 %dist = Vector::getDistance(%thisPos, %targetPos);
 %client = Player::getClient(%target);
 if(%dist <= 50)
 {
//  if($SnareTrap[%target] == True)
//  {
   if($SnareCanShoot[%client] == True)
   {
	SnareTrapTrap(%this, %target);
	$SnareCanShoot[%client] = False;
   }
 // }
  return True;
 }
 else
 {
  return False;
 }
 echo("Turret Range = "@%this.range);
 echo("Current Dist = "@%dist);
}

MiniMod::MonitorFile(stop, "SnareTrapTrap.CodeFusion.cs", "Area of effect gravity weapon.");
